<?php

namespace App\Http\Controllers\Entidad;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Expediente;
use App\Models\Archivo;
use App\Models\ExpedienteArchivo;
use Illuminate\Support\Facades\Auth;
use Yajra\DataTables\Contracts\DataTables;

use Illuminate\Support\Str;

class TramiteController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:entidad');
    }

    public function index(Request $request)
    {

        if ($request->input('datatable')) {
            $id_entidad = Auth::user()->id;
            $response = DB::table("expediente as e")
                        ->select(
                            "e.id as RowId",
                            "e.solicitud_codigo as SolicitudCodigo",
                            "e.codigo as CodigoExpediente",
                            "e.numero_expediente as NumeroDocumento",
                            DB::raw("DATE_FORMAT(e.created_at,'%d/%m/%Y %h:%i %p') as FechaReg"),
                            "e.asunto as Asunto",
                            "e.comentario as Comentario",
                            DB::raw("CASE 
                                    WHEN e.estado = 0 THEN 'Pendiente'
                                    WHEN e.estado = 1 THEN 'En tramite'
                                    WHEN e.estado = 2 THEN 'Rechazado'
                                    ELSE 'Pendiente'
                                    END AS Estado"),
                            "e.estado as EstadoNumero",
                            DB::raw('"" as Botones')
                        )
                        ->where("e.id_entidad",$id_entidad)
                        ->orderBy("e.created_at","desc");

            if(isset($request->estado)):
                $response = $response->where('e.estado',$request->estado);
            endif;
            // $response = $response->get();
            // return DataTables::of($response)
            //         ->make('true'); 
            return DataTables()->query($response)->toJson();
        }
        return view('entidad.tramite.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $oficina = DB::table("oficina")
                    ->get();
        // dd($oficina);            
        // $obj = new \stdClass;
                   
        foreach ($oficina as $key => $value) {
            $formatos = DB::table("formato")
                        ->where("id_oficina",$value->id)
                        ->get();

            $obj[$key] = new \stdClass; 
            $obj[$key]->id = $value->id; 
            $obj[$key]->oficina = $value->nombre; 
            $obj[$key]->formatos = $formatos; 
        }

        $response["formatos"] = $obj;
        // dd($response);

        $response["tipo"] = DB::table("expediente_tipo")
                        ->where("tipo",0)
                        ->get();
        return view("entidad.tramite.create",$response);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request);
        // $name = $request->file("archivo")->getClientOriginalName();
        // dd(Str::slug($name,' '));
        // dd(strtotime("now"));
        DB::beginTransaction();
        try {  

            $id_entidad = Auth::user()->id;

            $periodo = DB::table("periodo")
                ->where("estado",1)
                ->orderBy("id","desc")
                ->first();

            $query = DB::table("expediente")
                ->select("solicitud_numero as numero")
                ->where("id_periodo",$periodo->id)
                ->orderBy("solicitud_numero","desc")
                ->first();
                $numero = 1;

            if($query){
                $numero = (int)$query->numero + 1;
            }
            // $periodo = "19";
            $codigo= "S-".str_pad($numero, 6, "0", STR_PAD_LEFT)."-".$periodo->nombre;


            $data = new Expediente;
            $data->solicitud_numero = $numero;
            $data->solicitud_codigo = $codigo;
            $data->numero_expediente = $request->n_documento;
            $data->id_expediente_tipo = $request->expediente_tipo;
            $data->folio = $request->n_folio;
            $data->asunto = $request->asunto;
            $data->comentario = $request->comentario;
            $data->tipo = 0;
            $data->fecha_reg = date("Y-m-d");
            $data->id_periodo = $periodo->id;
            $data->id_entidad = $id_entidad;
            $data->save();

            $id = $data->id;
            try {
                
                // if($request->file("archivo")){
                foreach ($request->file("archivo") as $key => $value) {
                
                    $doc = $value;
                    $name = $doc->getClientOriginalName();
                    $slug = Str::slug($name,' ');

                    $nombre = strtotime("now")."-".$slug.".".$doc->getClientOriginalExtension();

                    $ruta = '/documentos/expedientes/externo/'.$periodo->nombre.'/'.$request->expediente_tipo.'/';
                    $destino = public_path($ruta);
                    $succ = $doc->move($destino,$nombre);

                    $archivo = new Archivo;
                    // $archivo->id_expediente = $id;
                    $archivo->nombre = $slug;
                    $archivo->enlace = $ruta.$nombre;
                    // $archivo->tipo = 0;
                    $archivo->save();

                    $expe_archivo = new ExpedienteArchivo;
                    $expe_archivo->id_expediente = $id;
                    $expe_archivo->id_archivo = $archivo->id;
                    // $expe_archivo->nombre = $slug;
                    // $expe_archivo->enlace = $ruta.$nombre;
                    $expe_archivo->tipo = 0;
                    $expe_archivo->save();
                }    
                // }
                    
            } catch (\Exception $e) {
                DB::rollback();
                $message = 'Archivos no Subidos.';
                $status = false;

                $response["status"] = $status;
                $response["message"] = $message;
                return $response;
            } 

            DB::commit();
            $message = 'Guardado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Guardar. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function revisar($id){
        $response["expediente"] = DB::table("expediente as e")
                ->select(
                    "e.id as RowId",
                    "e.solicitud_codigo as SolicitudCodigo",
                    "e.codigo as CodigoExpediente",
                    "e.numero_expediente as NumeroDocumento",
                    DB::raw("DATE_FORMAT(e.created_at,'%d/%m/%Y %h:%i %p') as FechaReg"),
                    "e.asunto as Asunto",
                    "e.folio as Folio",
                    "e.comentario as Comentario",
                    "e.archivo as Archivo",
                    DB::raw("CASE 
                            WHEN e.estado = 0 THEN 'Pendiente'
                            WHEN e.estado = 1 THEN 'En tramite'
                            WHEN e.estado = 2 THEN 'Rechazado'
                            ELSE 'Pendiente'
                            END AS Estado"),
                    "e.estado",
                    "e.observacion as Observacion",

                    DB::raw("CASE 
                            WHEN en.tipo = 0 THEN 'Persona Natural'
                            WHEN en.tipo = 1 THEN 'Persona Juridica'
                            ELSE ''
                            END AS TipoPersona"),
                    "en.tipo",
                    "td.nombre as TipoDocumento",
                    DB::raw("CONCAT(en.documento,' | ',en.paterno,' ',en.materno,' ',en.nombres) as Responsable"),
                    "en.telefono as Telefono",
                    "en.email as Email",
                    "en.direccion as Direccion",
                    "en.id_ubigeo as Ubigeo",
                    DB::raw("CONCAT(em.ruc,' | ',em.empresa) as Empresa"),
                    "em.direccion as DireccionEmpresa",

                    DB::raw('"" as Botones')
                )
                ->join("entidad as en","en.id","e.id_entidad")
                ->leftJoin("empresa as em","em.id","en.id_empresa")
                ->join("tipo_documento as td","td.id","en.id_tipo_documento")
                ->leftJoin("expediente_tipo as et","et.id","e.id_expediente_tipo")
                ->where("e.id",$id)
                ->first();

        $response['distrito'] = DB::table('ubigeo')
                            ->select('nombre','provincia','departamento')
                            ->where('id',$response["expediente"]->Ubigeo)
                            ->first();

        $response['provincia'] = DB::table('ubigeo')
                        ->select('nombre')
                        ->where('provincia',$response['distrito']->provincia)
                        ->where('departamento',$response['distrito']->departamento)
                        ->where('distrito','0')
                        ->first();

        $response['departamento'] = DB::table('ubigeo')
                        ->select('nombre')
                        ->where('departamento',$response['distrito']->departamento)
                        ->where('provincia','0')
                        ->where('distrito','0')
                        ->first();

        $response["archivo_solicitante"] = DB::table("expediente_archivo as ea")
                                ->select("a.nombre","a.enlace","ea.tipo")
                                ->join("archivo as a","a.id","ea.id_archivo")
                                ->where("ea.id_expediente",$id)
                                ->where("ea.tipo",0)
                                ->get();
        $response["archivo_resultado"] = DB::table("expediente_archivo as ea")
                                ->select("a.nombre","a.enlace","ea.tipo","o.nombre as Oficina")
                                ->join("archivo as a","a.id","ea.id_archivo")
                                ->join("oficina as o","o.id","a.id_oficina")
                                ->where("ea.id_expediente",$id)
                                ->where("ea.tipo",2)
                                ->get();

        return view("entidad.tramite.revisar",$response);
        // dd($response);
    }

    public function seguimiento($id){
        $response["tramite"] = DB::table("tramite as t")
                ->select(
                    "o.nombre as Oficina",
                    DB::raw("IFNULL(od.nombre, '') as Destino"),
                    DB::raw("CASE 
                            WHEN t.estado = 0 THEN 'Pendiente'
                            WHEN t.estado = 1 THEN 'Recibido'
                            WHEN t.estado = 2 THEN 'Derivado'
                            WHEN t.estado = 3 THEN 'Rechazado'
                            WHEN t.estado = 4 THEN 'Finalizado'
                            WHEN t.estado = 5 THEN 'Archivado'
                            ELSE ''
                            END AS Estado"),
                    DB::raw("IFNULL(t.observacion,'') as Observacion")
                )
                ->join("oficina as o","o.id","t.id_oficina")
                ->leftJoin("oficina as od","od.id","t.id_oficina_destino")
                ->where("t.id_expediente",$id)
                ->where("t.copia",0)
                ->orderBy("t.id","asc")
                ->get();
        return $response;
    }

}
