<?php

namespace App\Http\Controllers\Entidad;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;
use App\Models\Entidad;

class ActivationController extends Controller
{
    public function activate($id){
    	DB::beginTransaction();
        try {  

    		$id_de = Crypt::decryptString($id);

            $data = Entidad::find($id_de);
            $data->status = 1;
            $data->save();

            DB::commit();
            // $message = 'Guardado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            // $message = 'Error al Guardar. Intente otra vez.';
            $status = false;
        }
        return redirect('/entidad/login')->with('status',$status);
        // $response["status"] = $status;
        // $response["message"] = $message;
        // return $response;
    }
}
