<?php

namespace App\Http\Controllers\Auth\Login;

// use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Auth\LoginController as DefaultLoginController;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use App\Models\Entidad;
use App\Models\Empresa;
use App\Mail\ActivacionMail;
use Illuminate\Support\Facades\Crypt;

class EntidadController extends DefaultLoginController
{
    protected $redirectTo = '/entidad/tramite';
    public function __construct()
    {
        $this->middleware('guest:entidad')->except('logout');
    }
    public function username()
    {
        return 'documento';
    }
    protected function guard()
    {
        return Auth::guard('entidad');
    }
    public function showLoginForm()
    {
        return view('auth.login.entidad');
    }
    public function showRegisterForm()
    {
        return view('auth.login.register');
    }
    public function StoreRegister(Request $request){
        // dd($request);
        DB::beginTransaction();
        try {  

            // $id_de = Crypt::decryptString($id);

            $data = new Entidad;

            if($request->tipo_persona==1){
                if($request->empresa=="true"){
                    // echo "existe la empresa";
                    $id_empresa = $request->idempresa;
                }else{
                    // echo "existe no empresa";
                    $empresa = new Empresa;
                    $empresa->ruc = $request->ruc;
                    $empresa->empresa = $request->razon_social;
                    $empresa->direccion = $request->direccion_empresa;
                    $empresa->save();
                    $id_empresa = $empresa->id;
                }
                $data->tipo = 1;
                $data->id_empresa = $id_empresa;
                // $data->ruc = $request->ruc;
                // $data->empresa = $request->razon_social;
                // $data->direccion_empresa = $request->direccion_empresa;
            }else{
                $data->tipo = 0;
            }

            $data->id_tipo_documento = $request->tipo_documento;
            $data->documento = $request->documento;
            $data->paterno = strtoupper($request->paterno);
            $data->materno = strtoupper($request->materno);
            $data->nombres = strtoupper($request->nombres);
            $data->id_ubigeo = $request->distrito;
            $data->direccion = $request->direccion;
            $data->telefono = $request->telefono;
            $data->email = $request->email;
            $data->password = bcrypt($request->password);
            $data->pass = $request->password;
            $data->save();

            // try {  

                $id_en = Crypt::encryptString($data->id);
                $mensaje["nombres"] = $data->nombres;
                $mensaje["apellidos"] = $data->paterno." ".$data->materno;
                $mensaje["url"] = url("/activation/".$id_en);
                $mensaje["documento"] = $data->documento;
                $mensaje["clave"] = $data->pass;
            // Mail::to($request->email)->send(new ActivacionMail($mensaje));
                Mail::to($data->email)->send(new ActivacionMail($mensaje));

            // } catch (\Exception $e) {
                // $message = 'Error al Guardar. Intente otra vez.';
                // $status = false;
            // }

            DB::commit();
            $message = 'Registro Exitoso.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Sucedio un inconveniente al Registrar. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }
}
