<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use GuzzleHttp\Client;
use Illuminate\Http\Request;

class ApiController extends Controller
{

    public function obtenerDni($dni)
    {
        $client = new Client();

        try {
            // consulta DNI
            $response = $client->request('GET', 'http://api.sunat.dev/dni/' . 
            $dni . '?apikey=XUPoqn9Qqck0g3hQ7q90VleZWS3V6tLVl0dfcKSNhOEFK5tBiyQPDC7M9XdSTwAf');

            /**
             * consulta RUC
             * https://api.sunat.dev/ruc/20100047218?apikey=XUPoqn9Qqck0g3hQ7q90VleZWS3V6tLVl0dfcKSNhOEFK5tBiyQPDC7M9XdSTwAf
             * FORMATO DE RESPUESTA
             */
            /*
            {
                "statusCode": 200,
                "body": {
                    "apePaterno": "LARUTA",
                    "apeMaterno": "CALCINA",
                    "ubigeo": {
                    "distrito": "AZANGARO",
                    "latitud": "-14.9081",
                    "macroregion_inei": "SUR",
                    "iso_3166_2": "PE-PUN",
                    "fips": "21",
                    "ubigeo_inei": "210201",
                    "ubigeo_reniec": "200201",
                    "provincia": "AZANGARO",
                    "id_ubigeo": "1646",
                    "Frontera": "NO",
                    "longitud": "-70.1956",
                    "provincia_inei": "2102",
                    "superficie": "706",
                    "altitud": "3878",
                    "departamento_inei": "21",
                    "departamento": "PUNO",
                    "macroregion_minsa": "MACROREGION SUR",
                    "region": "PUNO"
                    },
                    "desDireccion": "JR.AZANGARO 740",
                    "preNombres": "KEVIN ARNOLD",
                    "nuDni": "70143926",
                    "feNacimiento": "18/06/1995"
                }
            }
            */

            $data = json_decode($response->getBody(), true);

            // Procesa los datos aquí

            return response()->json($data);
        } catch (\Exception $e) {
            // Manejar errores
            return response()->json(['error' => 'Error al consumir la API: ' . $e->getMessage()], 500);
        }
    }
    /**
     * Obtiene información sobre un número de RUC utilizando la API de SUNAT.
     *
     * $ruc El número de RUC a consultar.
     * return JsonResponse La información obtenida de la API de SUNAT en formato JSON.
     * abajo se ve el formato de respuesta
     */
    public function obtenerRuc($ruc)
    {
        $client = new Client();

        try {
            // consulta DNI
            $response = $client->request('GET', 'http://api.sunat.dev/ruc/' . $ruc . '?apikey=XUPoqn9Qqck0g3hQ7q90VleZWS3V6tLVl0dfcKSNhOEFK5tBiyQPDC7M9XdSTwAf');

            /**
             * consulta RUC
             * https://api.sunat.dev/ruc/20100047218?apikey=XUPoqn9Qqck0g3hQ7q90VleZWS3V6tLVl0dfcKSNhOEFK5tBiyQPDC7M9XdSTwAf
             * formato de respuesta
             *  
             */
            /*
            {
                "statusCode": 200,
                "body": {
                    "numeroRuc": "20448261272",
                    "datosContribuyente": {
                        "desRazonSocial": "UNIVERSIDAD NACIONAL DE JULIACA",
                        "desNomApe": "UNIVERSIDAD NACIONAL DE JULIACA",
                        "ubigeo": {
                            "codUbigeo": "211101",
                            "desDistrito": "JULIACA",
                            "desProvincia": "SAN ROMAN",
                            "desDepartamento": "PUNO"
                        },
                        "desDireccion": "AV. NUEVA ZELANDIA NRO. 631 LA CAPILLA",
                        "codEstado": "ACTIVO",
                        "codDomHabido": "HABIDO"
                    }
                }
            }
             */

            $data = json_decode($response->getBody(), true);

            // Procesa los datos aquí

            return response()->json($data);
        } catch (\Exception $e) {
            // Manejar errores
            return response()->json(['error' => 'Error al consumir la API: ' . $e->getMessage()], 500);
        }
    }
}
