<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Models\Postres;
use App\Models\FirmaParametros as FP;
use App\Models\Firma as F;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class PostresController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $postres = Postres::all();
        return response()->json($postres);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $postres = new Postres;
        $postres->nombre = $request->nombre;
        $postres->precio = $request->precio;
        $postres->stock = $request->stock;
        $postres->save();

        return response()->json([
            "message" => "Registro Agregado Correctamente !"
        ]);

    }

    /**
     * Display the specified resource.
     */
    public function show($id)
    {
        $postres = Postres::find($id);

        if(!empty($postres)) {
            return response()->json($postres);
        }
        else {
            return response()->json([
                "message" => "El Registro no se encuentra."
            ]);
        }

    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $postres = Postres::find($id);

        $postres->nombre = $request->nombre;
        $postres->precio = $request->precio;
        $postres->stock = $request->stock;
        $postres->save();

        return response()->json([
            "message" => "Registro Actualizado Correctamente !"
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $postres = Postres::find($id);
        $postres->delete();

        return response()->json([
            "message" => "Registro Eliminado Correctamente !"
        ]);
    }
    /**
     * parametros
     * 
     * Obtiene el json de parametros para un determinado 
     * documento a firmar 
     * 
     */
    public function parametros($fp_ide)
    {

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {

            $documentoFirma = FP::find($fp_ide);
            if ($documentoFirma) {
                // Eliminar las columnas que no deseas
                $documentoFirma->makeHidden(['fir_ide', 'param_url', 'id','param_token']);

                // Obtener los datos como un array
                $respuesta = $documentoFirma->toArray();
                header('Content-Type: application/x-www-form-urlencoded');
                $json = json_encode($respuesta);
                $base64 = base64_encode($json);
                echo $base64;
            } else {
                // Manejar el caso en que no se encuentra ningún resultado
                return response()->json(['error' => 'No se encontró el documento de firma'], 404);
            }
        } else {
            // Si la solicitud no es POST, enviar un mensaje de error
            http_response_code(405); // Method Not Allowed
            echo http_build_query(array('error' => 'Método no permitido'));
        }
    }
    public function subirpdf($fir_ide)
    {
        // el documento llega con nombre signed_file
        $documentoFirma = F::find($fir_ide);

        $file = request()->file('signed_file');

        // Definir la ruta de destino
        $destinationPath = '/firma/';

        // Si es necesario, crea el directorio para los documentos firmados
        if (!Storage::exists($destinationPath)) {
            Storage::makeDirectory($destinationPath);
        }

        // Generar un nombre único para el archivo basado en el ID y el nombre original
        $filename = $documentoFirma->fir_file_path;
        $path = $filename;

        // Eliminar el archivo existente si ya existe
        if (Storage::exists($path)) {
            Storage::delete($path);
        }

        // Mover el archivo a la ubicación de destino
        $storedPath = $file->storeAs($destinationPath, $filename);

        if ($storedPath) {
            return response()->json(['message' => 'Documento firmado guardado con éxito como: ' . $storedPath], 200);
        } else {
            return response()->json(['error' => 'Error al guardar el documento firmado.'], 500);
        }
    }



}
